include(`domains.m4')
form : type. %name form F.

% Basic logical connectives.
==> : form -> form -> form. %infix right 1 ==>.
\/ : form -> form -> form. %infix left 2 \/.
/\ : form -> form -> form. %infix left 3 /\.
top : form.
undivert(DIV_FORM)

% nat+ : nat -> form.
data+ : data D -> form.

skel : type. %name skel M.
skel/bin : skel -> skel -> skel.
skel/una : skel -> skel.
skel/nul : skel.

%abbrev
dp-z : data @top = @top/top.

% We can show that case analysis over nested derivations is sound as
% long as we do not have mutually recursive judgments. We use prec to
% `define' an implicit order on judgments.
prec : type. %name prec P.
prec/zero : prec.
prec/succ : prec -> prec.

msre : form
              -> skel   % Form skel
%              -> prec     % Auxiliary skel 1
              -> data D   % Auxiliary skel 2
%              -> nat      % Auxiliary skel 3
              -> type. %name msre RP.
msre/imp : msre (F1 ==> F2) (skel/bin M1 M2) dp-z
                  <- msre F1 M1 _
                  <- msre F2 M2 _.
msre/or : msre (F1 \/ F2) (skel/bin M1 M2) dp-z
                 <- msre F1 M1 _
                 <- msre F2 M2 _.
msre/and : msre (F1 /\ F2) (skel/bin M1 M2) dp-z
                  <- msre F1 M1 _
                  <- msre F2 M2 _.
msre/top : msre top skel/nul dp-z.
undivert(DIV_METRIC_RED)

msre/data+ : msre (data+ DP) skel/nul DP.

msre-tot : {F} msre F M DP -> type.
%mode msre-tot +F -RP.

- : msre-tot (F1 ==> F2) (msre/imp RP2 RP1)
     <- msre-tot F1 RP1
     <- msre-tot F2 RP2.
- : msre-tot (F1 \/ F2) (msre/or RP2 RP1)
     <- msre-tot F1 RP1
     <- msre-tot F2 RP2.
- : msre-tot (F1 /\ F2) (msre/and RP2 RP1)
     <- msre-tot F1 RP1
     <- msre-tot F2 RP2.
- : msre-tot top msre/top.
undivert(DIV_METRIC_TOT)

- : msre-tot (data+ DP) msre/data+.

divert(-1)
undivert